path='XXX\Supplemental Materials\Demo_Data\';

load([path 'Theta']) % runoff routing time
mask=imread([path '02083000_mask.tif']); % mask of basin
Area=find((mask==1));

ral=ls([path '\RainAct\RainAct*.tif']); % List of rainfall files
eal=ls([path '\EAct\EAct*.tif']); % List of actual evapotranspiration files
sml=ls([path '\SM\SM*.tif']); % List of soil moisture files

Qs=csvread([path '02083000.csv'],1,1);
bf=3.6*Qs(:,2)/size(Area,1); % simulated baseflow hydrograph
Qo=3.6*Qs(:,3)/size(Area,1); % observed flow hydrograph
Qs=3.6*Qs(:,1)/size(Area,1); % simulated streamflow hydrograph

WM=198.4444; % maximum water capacity
IM=0.10934025; % impervious ratio
coeS=0.6274482; %

P=nan(size(mask,1),size(mask,2),size(ral,1));
WI=nan(size(mask,1),size(mask,2),size(ral,1));
CCI=nan(size(ral,1),1);
CCO=nan(size(ral,1),1);

for h=1:size(ral,1)
%% Variable P of the framework
  era=imread([path '\RainAct\' ral(h,:)]); % rainfall map of each hour
  era(mask<0)=NaN;
  era(era<0)=0;

  eea=imread([path '\EAct\' eal(h,:)]); % EAT map of each hour
  eea(mask<0)=NaN;
  eea(eea<0)=0;

  er=era-eea; % subtract EAT from rainfall
  er(er<0)=0;
  P(:,:,h)=er; % variable P of the framework

%% Variable W of the framework
  esm=imread([path '\SM\' sml(h,:)]); % soil moisture of each hour
  esm(mask<0)=NaN;

  WI(:,:,h)=esm/WM; % subsurface runoff coefficient
  RI=er.*esm/WM; % subsurface rainfall excess component

  RO=er*IM; % surface rainfall excess component

  cc=cov(Theta{1}(Area),RI(Area),1);
  CCI(h)=cc(2,1); % {(Theta1,R1)}a
  cc=cov(Theta{2}(Area),RO(Area),1);
  CCO(h)=cc(2,1); % {(Theta2,R2)}a
end

WO=WI;
WO(WI>=0)=IM; % surface runoff coefficient

%% Terms in the analytical framework equations
[TS,AM,afv]=AFV(mask,P,WO,WI);
afc=AFC(afv(2,:),afv(8,:),TS(:,11:13),AM(:,:,11:13),coeS,Theta{1},Theta{2});
afs=AFS(TS(:,11:13),AM(:,:,11:13),afv(8,:),afc(1,:),afc(4,:),Theta{1},...
        Theta{2},afc(5,:),afc(8,:),CCI,CCO);

%% Hydrograph properties
aff=AFF((1:length(Qs)),Qs,bf); % Model simulation
affo=AFF((1:length(Qo)),Qo,bf); % Observation
